﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Inet.Viewer.WinForms.Export
{

    /// <summary>
    /// A panel with format-specific export options. 
    /// </summary>
    public class FormatSettingsControl : UserControl
    {
        /// <summary>
        /// The icon to show in the selection panel.
        /// </summary>
        public virtual Bitmap Icon { get { return null; } }

        /// <summary>
        /// The label to show in the selection panel.
        /// </summary>
        public virtual string Label { get { return null; } }

        /// <summary>
        /// The file suffix of this format.
        /// </summary>
        public virtual string FileSuffix { get { return null; } }
        
        /// <summary>
        /// Sets a flag indicating whether the report is a multi-page report (when rendering with the viewer).
        /// </summary>
        public virtual bool MultiPageReport { set { } }

        /// <summary>
        /// Sets a flag indicating whether the report has any groups.
        /// </summary>
        public virtual bool HasGroups { set { } }

        /// <summary>
        /// Called when the format changes. This happens in multi format settings
        /// controls only, e.g. ImageSettingsControl
        /// </summary>
        public event EventHandler FormatChanged;

        /// <summary>
        /// Adds the parameters set in this control to the specified dictionary.
        /// </summary>
        /// <param name="expParams"></param>
        public virtual void CollectExportParameters(Dictionary<string, string> expParams)
        {
        }

        /// <summary>
        /// Fires a format changed event.
        /// </summary>
        protected void OnFormatChanged()
        {
            if (FormatChanged != null)
            {
                FormatChanged.Invoke(this, new EventArgs());
            }
        }

        /// <summary>
        /// Sets the set of allowed formats. Updates the Allowed flag of this control in respect 
        /// to the specified set.
        /// </summary>
        virtual public HashSet<string> AllowedFormats { 
             set {
                Allowed = value.Count == 0 || value.Contains(FileSuffix);
            }
        }

        /// <summary>
        /// Gets a flag indicating whether this format is allowed. 
        /// </summary>
        public bool Allowed { get; set; }
    }
}
